package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  Size,
  LastModified,
  DashboardArn,
  DashboardName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DashboardEntry(
    dashboardName: Option[DashboardName] = None,
    dashboardArn: Option[DashboardArn] = None,
    lastModified: Option[LastModified] = None,
    size: Option[Size] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DashboardEntry = {
    import DashboardEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
      .builder()
      .optionallyWith(dashboardName.map(value => value: java.lang.String))(
        _.dashboardName
      )
      .optionallyWith(dashboardArn.map(value => value: java.lang.String))(
        _.dashboardArn
      )
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.wrap(buildAwsValue())
}
object DashboardEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry =
      io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry(
        dashboardNameValue.map(value => value),
        dashboardArnValue.map(value => value),
        lastModifiedValue.map(value => value),
        sizeValue.map(value => value)
      )
    def dashboardNameValue: Option[DashboardName]
    def dashboardArnValue: Option[DashboardArn]
    def lastModifiedValue: Option[LastModified]
    def sizeValue: Option[Size]
    def dashboardName: ZIO[Any, AwsError, DashboardName] =
      AwsError.unwrapOptionField("dashboardName", dashboardNameValue)
    def dashboardArn: ZIO[Any, AwsError, DashboardArn] =
      AwsError.unwrapOptionField("dashboardArn", dashboardArnValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def size: ZIO[Any, AwsError, Size] =
      AwsError.unwrapOptionField("size", sizeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly {
    override def dashboardNameValue: Option[DashboardName] =
      scala.Option(impl.dashboardName()).map(value => value: DashboardName)
    override def dashboardArnValue: Option[DashboardArn] =
      scala.Option(impl.dashboardArn()).map(value => value: DashboardArn)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def sizeValue: Option[Size] =
      scala.Option(impl.size()).map(value => value: Size)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardEntry
  ): io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly =
    new Wrapper(impl)
}
