package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{Message, DataPath}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DashboardValidationMessage(
    dataPath: Option[DataPath] = None,
    message: Option[Message] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage = {
    import DashboardValidationMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
      .builder()
      .optionallyWith(dataPath.map(value => value: java.lang.String))(
        _.dataPath
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage
      .wrap(buildAwsValue())
}
object DashboardValidationMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage =
      io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage(
        dataPathValue.map(value => value),
        messageValue.map(value => value)
      )
    def dataPathValue: Option[DataPath]
    def messageValue: Option[Message]
    def dataPath: ZIO[Any, AwsError, DataPath] =
      AwsError.unwrapOptionField("dataPath", dataPathValue)
    def message: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage.ReadOnly {
    override def dataPathValue: Option[DataPath] =
      scala.Option(impl.dataPath()).map(value => value: DataPath)
    override def messageValue: Option[Message] =
      scala.Option(impl.message()).map(value => value: Message)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage
  ): io.github.vigoo.zioaws.cloudwatch.model.DashboardValidationMessage.ReadOnly =
    new Wrapper(impl)
}
