package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  ExtendedStatistic,
  DatapointValue,
  Timestamp
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Datapoint(
    timestamp: Option[Timestamp] = None,
    sampleCount: Option[DatapointValue] = None,
    average: Option[DatapointValue] = None,
    sum: Option[DatapointValue] = None,
    minimum: Option[DatapointValue] = None,
    maximum: Option[DatapointValue] = None,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None,
    extendedStatistics: Option[Map[ExtendedStatistic, DatapointValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Datapoint = {
    import Datapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Datapoint
      .builder()
      .optionallyWith(timestamp.map(value => value: Instant))(_.timestamp)
      .optionallyWith(sampleCount.map(value => value: java.lang.Double))(
        _.sampleCount
      )
      .optionallyWith(average.map(value => value: java.lang.Double))(_.average)
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        extendedStatistics.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Double)
            })
            .asJava
        )
      )(_.extendedStatistics)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.Datapoint.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.Datapoint.wrap(buildAwsValue())
}
object Datapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.Datapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.Datapoint =
      io.github.vigoo.zioaws.cloudwatch.model.Datapoint(
        timestampValue.map(value => value),
        sampleCountValue.map(value => value),
        averageValue.map(value => value),
        sumValue.map(value => value),
        minimumValue.map(value => value),
        maximumValue.map(value => value),
        unitValue.map(value => value),
        extendedStatisticsValue.map(value => value)
      )
    def timestampValue: Option[Timestamp]
    def sampleCountValue: Option[DatapointValue]
    def averageValue: Option[DatapointValue]
    def sumValue: Option[DatapointValue]
    def minimumValue: Option[DatapointValue]
    def maximumValue: Option[DatapointValue]
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def extendedStatisticsValue: Option[Map[ExtendedStatistic, DatapointValue]]
    def timestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestampValue)
    def sampleCount: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("sampleCount", sampleCountValue)
    def average: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("average", averageValue)
    def sum: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("sum", sumValue)
    def minimum: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("minimum", minimumValue)
    def maximum: ZIO[Any, AwsError, DatapointValue] =
      AwsError.unwrapOptionField("maximum", maximumValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
    def extendedStatistics
        : ZIO[Any, AwsError, Map[ExtendedStatistic, DatapointValue]] =
      AwsError.unwrapOptionField("extendedStatistics", extendedStatisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Datapoint
  ) extends io.github.vigoo.zioaws.cloudwatch.model.Datapoint.ReadOnly {
    override def timestampValue: Option[Timestamp] =
      scala.Option(impl.timestamp()).map(value => value: Timestamp)
    override def sampleCountValue: Option[DatapointValue] =
      scala.Option(impl.sampleCount()).map(value => value: DatapointValue)
    override def averageValue: Option[DatapointValue] =
      scala.Option(impl.average()).map(value => value: DatapointValue)
    override def sumValue: Option[DatapointValue] =
      scala.Option(impl.sum()).map(value => value: DatapointValue)
    override def minimumValue: Option[DatapointValue] =
      scala.Option(impl.minimum()).map(value => value: DatapointValue)
    override def maximumValue: Option[DatapointValue] =
      scala.Option(impl.maximum()).map(value => value: DatapointValue)
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
    override def extendedStatisticsValue
        : Option[Map[ExtendedStatistic, DatapointValue]] = scala
      .Option(impl.extendedStatistics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: ExtendedStatistic) -> (value: DatapointValue)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Datapoint
  ): io.github.vigoo.zioaws.cloudwatch.model.Datapoint.ReadOnly = new Wrapper(
    impl
  )
}
