package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.AlarmName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAlarmsRequest(alarmNames: Iterable[AlarmName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest = {
    import DeleteAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
      .builder()
      .alarmNames(alarmNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DeleteAlarmsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DeleteAlarmsRequest
      .wrap(buildAwsValue())
}
object DeleteAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.DeleteAlarmsRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .DeleteAlarmsRequest(alarmNamesValue)
    def alarmNamesValue: List[AlarmName]
    def alarmNames: ZIO[Any, Nothing, List[AlarmName]] =
      ZIO.succeed(alarmNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DeleteAlarmsRequest.ReadOnly {
    override def alarmNamesValue: List[AlarmName] = impl
      .alarmNames()
      .asScala
      .map { item =>
        item: AlarmName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DeleteAlarmsRequest.ReadOnly =
    new Wrapper(impl)
}
