package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.DashboardName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDashboardsRequest(
    dashboardNames: Iterable[DashboardName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest = {
    import DeleteDashboardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
      .builder()
      .dashboardNames(dashboardNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsRequest
      .wrap(buildAwsValue())
}
object DeleteDashboardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .DeleteDashboardsRequest(dashboardNamesValue)
    def dashboardNamesValue: List[DashboardName]
    def dashboardNames: ZIO[Any, Nothing, List[DashboardName]] =
      ZIO.succeed(dashboardNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsRequest.ReadOnly {
    override def dashboardNamesValue: List[DashboardName] = impl
      .dashboardNames()
      .asScala
      .map { item =>
        item: DashboardName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DeleteDashboardsRequest.ReadOnly =
    new Wrapper(impl)
}
