package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.InsightRuleName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteInsightRulesRequest(
    ruleNames: Iterable[InsightRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest = {
    import DeleteInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
      .builder()
      .ruleNames(ruleNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesRequest
      .wrap(buildAwsValue())
}
object DeleteInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .DeleteInsightRulesRequest(ruleNamesValue)
    def ruleNamesValue: List[InsightRuleName]
    def ruleNames: ZIO[Any, Nothing, List[InsightRuleName]] =
      ZIO.succeed(ruleNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesRequest.ReadOnly {
    override def ruleNamesValue: List[InsightRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        item: InsightRuleName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
