package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteInsightRulesResponse(
    failures: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse = {
    import DeleteInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse
      .wrap(buildAwsValue())
}
object DeleteInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse(
        failuresValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def failuresValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly]
    ]
    def failures: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failuresValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly {
    override def failuresValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly]
    ] = scala
      .Option(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DeleteInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
