package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteMetricStreamRequest(name: MetricStreamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest = {
    import DeleteMetricStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamRequest
      .wrap(buildAwsValue())
}
object DeleteMetricStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .DeleteMetricStreamRequest(nameValue)
    def nameValue: MetricStreamName
    def name: ZIO[Any, Nothing, MetricStreamName] = ZIO.succeed(nameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamRequest.ReadOnly {
    override def nameValue: MetricStreamName = impl.name(): MetricStreamName
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DeleteMetricStreamRequest.ReadOnly =
    new Wrapper(impl)
}
