package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  NextToken,
  MaxRecords,
  Timestamp,
  AlarmName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAlarmHistoryRequest(
    alarmName: Option[AlarmName] = None,
    alarmTypes: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]
    ] = None,
    historyItemType: Option[
      io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType
    ] = None,
    startDate: Option[Timestamp] = None,
    endDate: Option[Timestamp] = None,
    maxRecords: Option[MaxRecords] = None,
    nextToken: Option[NextToken] = None,
    scanBy: Option[io.github.vigoo.zioaws.cloudwatch.model.ScanBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest = {
    import DescribeAlarmHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
      .builder()
      .optionallyWith(alarmName.map(value => value: java.lang.String))(
        _.alarmName
      )
      .optionallyWith(
        alarmTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.alarmTypesWithStrings)
      .optionallyWith(historyItemType.map(value => value.unwrap))(
        _.historyItemType
      )
      .optionallyWith(startDate.map(value => value: Instant))(_.startDate)
      .optionallyWith(endDate.map(value => value: Instant))(_.endDate)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(scanBy.map(value => value.unwrap))(_.scanBy)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryRequest
      .wrap(buildAwsValue())
}
object DescribeAlarmHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryRequest =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryRequest(
        alarmNameValue.map(value => value),
        alarmTypesValue.map(value => value),
        historyItemTypeValue.map(value => value),
        startDateValue.map(value => value),
        endDateValue.map(value => value),
        maxRecordsValue.map(value => value),
        nextTokenValue.map(value => value),
        scanByValue.map(value => value)
      )
    def alarmNameValue: Option[AlarmName]
    def alarmTypesValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]]
    def historyItemTypeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType]
    def startDateValue: Option[Timestamp]
    def endDateValue: Option[Timestamp]
    def maxRecordsValue: Option[MaxRecords]
    def nextTokenValue: Option[NextToken]
    def scanByValue: Option[io.github.vigoo.zioaws.cloudwatch.model.ScanBy]
    def alarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("alarmName", alarmNameValue)
    def alarmTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.AlarmType
    ]] = AwsError.unwrapOptionField("alarmTypes", alarmTypesValue)
    def historyItemType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType
    ] = AwsError.unwrapOptionField("historyItemType", historyItemTypeValue)
    def startDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDateValue)
    def endDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDate", endDateValue)
    def maxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def scanBy
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.cloudwatch.model.ScanBy] =
      AwsError.unwrapOptionField("scanBy", scanByValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryRequest.ReadOnly {
    override def alarmNameValue: Option[AlarmName] =
      scala.Option(impl.alarmName()).map(value => value: AlarmName)
    override def alarmTypesValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]] =
      scala
        .Option(impl.alarmTypes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.AlarmType.wrap(item)
          }.toList
        )
    override def historyItemTypeValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType] =
      scala
        .Option(impl.historyItemType())
        .map(value =>
          io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType.wrap(value)
        )
    override def startDateValue: Option[Timestamp] =
      scala.Option(impl.startDate()).map(value => value: Timestamp)
    override def endDateValue: Option[Timestamp] =
      scala.Option(impl.endDate()).map(value => value: Timestamp)
    override def maxRecordsValue: Option[MaxRecords] =
      scala.Option(impl.maxRecords()).map(value => value: MaxRecords)
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def scanByValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.ScanBy] = scala
      .Option(impl.scanBy())
      .map(value => io.github.vigoo.zioaws.cloudwatch.model.ScanBy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
