package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmHistoryResponse(
    alarmHistoryItems: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse = {
    import DescribeAlarmHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
      .builder()
      .optionallyWith(
        alarmHistoryItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarmHistoryItems)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryResponse
      .wrap(buildAwsValue())
}
object DescribeAlarmHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryResponse(
        alarmHistoryItemsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def alarmHistoryItemsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def alarmHistoryItems: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly
    ]] = AwsError.unwrapOptionField("alarmHistoryItems", alarmHistoryItemsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly {
    override def alarmHistoryItemsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.ReadOnly]
    ] = scala
      .Option(impl.alarmHistoryItems())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.AlarmHistoryItem.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
