package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  Period,
  ExtendedStatistic,
  Namespace,
  MetricName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsForMetricRequest(
    metricName: MetricName,
    namespace: Namespace,
    statistic: Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic] = None,
    extendedStatistic: Option[ExtendedStatistic] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    period: Option[Period] = None,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest = {
    import DescribeAlarmsForMetricRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
      .builder()
      .metricName(metricName: java.lang.String)
      .namespace(namespace: java.lang.String)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .optionallyWith(extendedStatistic.map(value => value: java.lang.String))(
        _.extendedStatistic
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(period.map(value => value: Integer))(_.period)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricRequest
      .wrap(buildAwsValue())
}
object DescribeAlarmsForMetricRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricRequest =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricRequest(
        metricNameValue,
        namespaceValue,
        statisticValue.map(value => value),
        extendedStatisticValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        periodValue.map(value => value),
        unitValue.map(value => value)
      )
    def metricNameValue: MetricName
    def namespaceValue: Namespace
    def statisticValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic]
    def extendedStatisticValue: Option[ExtendedStatistic]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def periodValue: Option[Period]
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def metricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricNameValue)
    def namespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespaceValue)
    def statistic: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.Statistic
    ] = AwsError.unwrapOptionField("statistic", statisticValue)
    def extendedStatistic: ZIO[Any, AwsError, ExtendedStatistic] =
      AwsError.unwrapOptionField("extendedStatistic", extendedStatisticValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def period: ZIO[Any, AwsError, Period] =
      AwsError.unwrapOptionField("period", periodValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricRequest.ReadOnly {
    override def metricNameValue: MetricName = impl.metricName(): MetricName
    override def namespaceValue: Namespace = impl.namespace(): Namespace
    override def statisticValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.Statistic] = scala
      .Option(impl.statistic())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.Statistic.wrap(value)
      )
    override def extendedStatisticValue: Option[ExtendedStatistic] = scala
      .Option(impl.extendedStatistic())
      .map(value => value: ExtendedStatistic)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def periodValue: Option[Period] =
      scala.Option(impl.period()).map(value => value: Period)
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricRequest.ReadOnly =
    new Wrapper(impl)
}
