package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsForMetricResponse(
    metricAlarms: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse = {
    import DescribeAlarmsForMetricResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
      .builder()
      .optionallyWith(
        metricAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricAlarms)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse
      .wrap(buildAwsValue())
}
object DescribeAlarmsForMetricResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse(
        metricAlarmsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def metricAlarmsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly]
    ]
    def metricAlarms: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
    ]] = AwsError.unwrapOptionField("metricAlarms", metricAlarmsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly {
    override def metricAlarmsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly]
    ] = scala
      .Option(impl.metricAlarms())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsForMetricResponse.ReadOnly =
    new Wrapper(impl)
}
