package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  NextToken,
  AlarmNamePrefix,
  AlarmName,
  MaxRecords,
  ActionPrefix
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsRequest(
    alarmNames: Option[Iterable[AlarmName]] = None,
    alarmNamePrefix: Option[AlarmNamePrefix] = None,
    alarmTypes: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]
    ] = None,
    childrenOfAlarmName: Option[AlarmName] = None,
    parentsOfAlarmName: Option[AlarmName] = None,
    stateValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue] =
      None,
    actionPrefix: Option[ActionPrefix] = None,
    maxRecords: Option[MaxRecords] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest = {
    import DescribeAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
      .builder()
      .optionallyWith(
        alarmNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alarmNames)
      .optionallyWith(alarmNamePrefix.map(value => value: java.lang.String))(
        _.alarmNamePrefix
      )
      .optionallyWith(
        alarmTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.alarmTypesWithStrings)
      .optionallyWith(
        childrenOfAlarmName.map(value => value: java.lang.String)
      )(_.childrenOfAlarmName)
      .optionallyWith(parentsOfAlarmName.map(value => value: java.lang.String))(
        _.parentsOfAlarmName
      )
      .optionallyWith(stateValue.map(value => value.unwrap))(_.stateValue)
      .optionallyWith(actionPrefix.map(value => value: java.lang.String))(
        _.actionPrefix
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsRequest
      .wrap(buildAwsValue())
}
object DescribeAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsRequest =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsRequest(
        alarmNamesValue.map(value => value),
        alarmNamePrefixValue.map(value => value),
        alarmTypesValue.map(value => value),
        childrenOfAlarmNameValue.map(value => value),
        parentsOfAlarmNameValue.map(value => value),
        stateValueValue.map(value => value),
        actionPrefixValue.map(value => value),
        maxRecordsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def alarmNamesValue: Option[List[AlarmName]]
    def alarmNamePrefixValue: Option[AlarmNamePrefix]
    def alarmTypesValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]]
    def childrenOfAlarmNameValue: Option[AlarmName]
    def parentsOfAlarmNameValue: Option[AlarmName]
    def stateValueValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue]
    def actionPrefixValue: Option[ActionPrefix]
    def maxRecordsValue: Option[MaxRecords]
    def nextTokenValue: Option[NextToken]
    def alarmNames: ZIO[Any, AwsError, List[AlarmName]] =
      AwsError.unwrapOptionField("alarmNames", alarmNamesValue)
    def alarmNamePrefix: ZIO[Any, AwsError, AlarmNamePrefix] =
      AwsError.unwrapOptionField("alarmNamePrefix", alarmNamePrefixValue)
    def alarmTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.AlarmType
    ]] = AwsError.unwrapOptionField("alarmTypes", alarmTypesValue)
    def childrenOfAlarmName: ZIO[Any, AwsError, AlarmName] = AwsError
      .unwrapOptionField("childrenOfAlarmName", childrenOfAlarmNameValue)
    def parentsOfAlarmName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("parentsOfAlarmName", parentsOfAlarmNameValue)
    def stateValue: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StateValue
    ] = AwsError.unwrapOptionField("stateValue", stateValueValue)
    def actionPrefix: ZIO[Any, AwsError, ActionPrefix] =
      AwsError.unwrapOptionField("actionPrefix", actionPrefixValue)
    def maxRecords: ZIO[Any, AwsError, MaxRecords] =
      AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsRequest.ReadOnly {
    override def alarmNamesValue: Option[List[AlarmName]] = scala
      .Option(impl.alarmNames())
      .map(value =>
        value.asScala.map { item =>
          item: AlarmName
        }.toList
      )
    override def alarmNamePrefixValue: Option[AlarmNamePrefix] =
      scala.Option(impl.alarmNamePrefix()).map(value => value: AlarmNamePrefix)
    override def alarmTypesValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.AlarmType]] =
      scala
        .Option(impl.alarmTypes())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.AlarmType.wrap(item)
          }.toList
        )
    override def childrenOfAlarmNameValue: Option[AlarmName] =
      scala.Option(impl.childrenOfAlarmName()).map(value => value: AlarmName)
    override def parentsOfAlarmNameValue: Option[AlarmName] =
      scala.Option(impl.parentsOfAlarmName()).map(value => value: AlarmName)
    override def stateValueValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StateValue] = scala
      .Option(impl.stateValue())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StateValue.wrap(value)
      )
    override def actionPrefixValue: Option[ActionPrefix] =
      scala.Option(impl.actionPrefix()).map(value => value: ActionPrefix)
    override def maxRecordsValue: Option[MaxRecords] =
      scala.Option(impl.maxRecords()).map(value => value: MaxRecords)
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsRequest.ReadOnly =
    new Wrapper(impl)
}
