package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAlarmsResponse(
    compositeAlarms: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm]
    ] = None,
    metricAlarms: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse = {
    import DescribeAlarmsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
      .builder()
      .optionallyWith(
        compositeAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compositeAlarms)
      .optionallyWith(
        metricAlarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricAlarms)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsResponse
      .wrap(buildAwsValue())
}
object DescribeAlarmsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsResponse(
        compositeAlarmsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        metricAlarmsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def compositeAlarmsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.ReadOnly]
    ]
    def metricAlarmsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def compositeAlarms: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.ReadOnly
    ]] = AwsError.unwrapOptionField("compositeAlarms", compositeAlarmsValue)
    def metricAlarms: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly
    ]] = AwsError.unwrapOptionField("metricAlarms", metricAlarmsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly {
    override def compositeAlarmsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.ReadOnly]
    ] = scala
      .Option(impl.compositeAlarms())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.CompositeAlarm.wrap(item)
        }.toList
      )
    override def metricAlarmsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.ReadOnly]
    ] = scala
      .Option(impl.metricAlarms())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricAlarm.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAlarmsResponse.ReadOnly =
    new Wrapper(impl)
}
