package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricName,
  Namespace,
  MaxReturnedResultsCount,
  NextToken
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAnomalyDetectorsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxReturnedResultsCount] = None,
    namespace: Option[Namespace] = None,
    metricName: Option[MetricName] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    anomalyDetectorTypes: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest = {
    import DescribeAnomalyDetectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        anomalyDetectorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.anomalyDetectorTypesWithStrings)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsRequest
      .wrap(buildAwsValue())
}
object DescribeAnomalyDetectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsRequest =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsRequest(
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value),
        namespaceValue.map(value => value),
        metricNameValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        anomalyDetectorTypesValue.map(value => value)
      )
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[MaxReturnedResultsCount]
    def namespaceValue: Option[Namespace]
    def metricNameValue: Option[MetricName]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def anomalyDetectorTypesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType]
    ]
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxReturnedResultsCount] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def anomalyDetectorTypes: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType
    ]] = AwsError.unwrapOptionField(
      "anomalyDetectorTypes",
      anomalyDetectorTypesValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsRequest.ReadOnly {
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[MaxReturnedResultsCount] = scala
      .Option(impl.maxResults())
      .map(value => value: MaxReturnedResultsCount)
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def anomalyDetectorTypesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType]
    ] = scala
      .Option(impl.anomalyDetectorTypes())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetectorType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsRequest.ReadOnly =
    new Wrapper(impl)
}
