package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAnomalyDetectorsResponse(
    anomalyDetectors: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse = {
    import DescribeAnomalyDetectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
      .builder()
      .optionallyWith(
        anomalyDetectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalyDetectors)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsResponse
      .wrap(buildAwsValue())
}
object DescribeAnomalyDetectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsResponse(
        anomalyDetectorsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def anomalyDetectorsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def anomalyDetectors: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalyDetectors", anomalyDetectorsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly {
    override def anomalyDetectorsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.ReadOnly]
    ] = scala
      .Option(impl.anomalyDetectors())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.AnomalyDetector.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeAnomalyDetectorsResponse.ReadOnly =
    new Wrapper(impl)
}
