package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleMaxResults,
  NextToken
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInsightRulesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[InsightRuleMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest = {
    import DescribeInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesRequest
      .wrap(buildAwsValue())
}
object DescribeInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesRequest =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesRequest(
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[InsightRuleMaxResults]
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, InsightRuleMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesRequest.ReadOnly {
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[InsightRuleMaxResults] =
      scala.Option(impl.maxResults()).map(value => value: InsightRuleMaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
