package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInsightRulesResponse(
    nextToken: Option[NextToken] = None,
    insightRules: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.InsightRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse = {
    import DescribeInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        insightRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.insightRules)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesResponse
      .wrap(buildAwsValue())
}
object DescribeInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesResponse(
        nextTokenValue.map(value => value),
        insightRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[NextToken]
    def insightRulesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def insightRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly
    ]] = AwsError.unwrapOptionField("insightRules", insightRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly {
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def insightRulesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly]
    ] = scala
      .Option(impl.insightRules())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.InsightRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DescribeInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
