package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  DimensionValue,
  DimensionName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Dimension(name: DimensionName, value: DimensionValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.Dimension = {
    import Dimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.Dimension
      .builder()
      .name(name: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(buildAwsValue())
}
object Dimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.Dimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.Dimension =
      io.github.vigoo.zioaws.cloudwatch.model.Dimension(nameValue, valueValue)
    def nameValue: DimensionName
    def valueValue: DimensionValue
    def name: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(nameValue)
    def value: ZIO[Any, Nothing, DimensionValue] = ZIO.succeed(valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.Dimension
  ) extends io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly {
    override def nameValue: DimensionName = impl.name(): DimensionName
    override def valueValue: DimensionValue = impl.value(): DimensionValue
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.Dimension
  ): io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly = new Wrapper(
    impl
  )
}
