package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  DimensionValue,
  DimensionName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DimensionFilter(
    name: DimensionName,
    value: Option[DimensionValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DimensionFilter = {
    import DimensionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter
      .wrap(buildAwsValue())
}
object DimensionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter =
      io.github.vigoo.zioaws.cloudwatch.model
        .DimensionFilter(nameValue, valueValue.map(value => value))
    def nameValue: DimensionName
    def valueValue: Option[DimensionValue]
    def name: ZIO[Any, Nothing, DimensionName] = ZIO.succeed(nameValue)
    def value: ZIO[Any, AwsError, DimensionValue] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.ReadOnly {
    override def nameValue: DimensionName = impl.name(): DimensionName
    override def valueValue: Option[DimensionValue] =
      scala.Option(impl.value()).map(value => value: DimensionValue)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DimensionFilter
  ): io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.ReadOnly =
    new Wrapper(impl)
}
