package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.AlarmName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableAlarmActionsRequest(alarmNames: Iterable[AlarmName]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest = {
    import DisableAlarmActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
      .builder()
      .alarmNames(alarmNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DisableAlarmActionsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DisableAlarmActionsRequest
      .wrap(buildAwsValue())
}
object DisableAlarmActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DisableAlarmActionsRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .DisableAlarmActionsRequest(alarmNamesValue)
    def alarmNamesValue: List[AlarmName]
    def alarmNames: ZIO[Any, Nothing, List[AlarmName]] =
      ZIO.succeed(alarmNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DisableAlarmActionsRequest.ReadOnly {
    override def alarmNamesValue: List[AlarmName] = impl
      .alarmNames()
      .asScala
      .map { item =>
        item: AlarmName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DisableAlarmActionsRequest.ReadOnly =
    new Wrapper(impl)
}
