package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.InsightRuleName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableInsightRulesRequest(
    ruleNames: Iterable[InsightRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest = {
    import DisableInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
      .builder()
      .ruleNames(ruleNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesRequest
      .wrap(buildAwsValue())
}
object DisableInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .DisableInsightRulesRequest(ruleNamesValue)
    def ruleNamesValue: List[InsightRuleName]
    def ruleNames: ZIO[Any, Nothing, List[InsightRuleName]] =
      ZIO.succeed(ruleNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesRequest.ReadOnly {
    override def ruleNamesValue: List[InsightRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        item: InsightRuleName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
