package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableInsightRulesResponse(
    failures: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse = {
    import DisableInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
      .builder()
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse
      .wrap(buildAwsValue())
}
object DisableInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse =
      io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse(
        failuresValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def failuresValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly]
    ]
    def failures: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failuresValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly {
    override def failuresValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.ReadOnly]
    ] = scala
      .Option(impl.failures())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.PartialFailure.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.DisableInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
