package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.InsightRuleName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableInsightRulesRequest(
    ruleNames: Iterable[InsightRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest = {
    import EnableInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
      .builder()
      .ruleNames(ruleNames.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesRequest
      .wrap(buildAwsValue())
}
object EnableInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .EnableInsightRulesRequest(ruleNamesValue)
    def ruleNamesValue: List[InsightRuleName]
    def ruleNames: ZIO[Any, Nothing, List[InsightRuleName]] =
      ZIO.succeed(ruleNamesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesRequest.ReadOnly {
    override def ruleNamesValue: List[InsightRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        item: InsightRuleName
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.EnableInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
