package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.DashboardName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDashboardRequest(dashboardName: DashboardName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest = {
    import GetDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
      .builder()
      .dashboardName(dashboardName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetDashboardRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetDashboardRequest
      .wrap(buildAwsValue())
}
object GetDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.GetDashboardRequest =
      io.github.vigoo.zioaws.cloudwatch.model
        .GetDashboardRequest(dashboardNameValue)
    def dashboardNameValue: DashboardName
    def dashboardName: ZIO[Any, Nothing, DashboardName] =
      ZIO.succeed(dashboardNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetDashboardRequest.ReadOnly {
    override def dashboardNameValue: DashboardName =
      impl.dashboardName(): DashboardName
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.GetDashboardRequest.ReadOnly =
    new Wrapper(impl)
}
