package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  DashboardName,
  DashboardBody,
  DashboardArn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDashboardResponse(
    dashboardArn: Option[DashboardArn] = None,
    dashboardBody: Option[DashboardBody] = None,
    dashboardName: Option[DashboardName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse = {
    import GetDashboardResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
      .builder()
      .optionallyWith(dashboardArn.map(value => value: java.lang.String))(
        _.dashboardArn
      )
      .optionallyWith(dashboardBody.map(value => value: java.lang.String))(
        _.dashboardBody
      )
      .optionallyWith(dashboardName.map(value => value: java.lang.String))(
        _.dashboardName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse
      .wrap(buildAwsValue())
}
object GetDashboardResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse =
      io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse(
        dashboardArnValue.map(value => value),
        dashboardBodyValue.map(value => value),
        dashboardNameValue.map(value => value)
      )
    def dashboardArnValue: Option[DashboardArn]
    def dashboardBodyValue: Option[DashboardBody]
    def dashboardNameValue: Option[DashboardName]
    def dashboardArn: ZIO[Any, AwsError, DashboardArn] =
      AwsError.unwrapOptionField("dashboardArn", dashboardArnValue)
    def dashboardBody: ZIO[Any, AwsError, DashboardBody] =
      AwsError.unwrapOptionField("dashboardBody", dashboardBodyValue)
    def dashboardName: ZIO[Any, AwsError, DashboardName] =
      AwsError.unwrapOptionField("dashboardName", dashboardNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly {
    override def dashboardArnValue: Option[DashboardArn] =
      scala.Option(impl.dashboardArn()).map(value => value: DashboardArn)
    override def dashboardBodyValue: Option[DashboardBody] =
      scala.Option(impl.dashboardBody()).map(value => value: DashboardBody)
    override def dashboardNameValue: Option[DashboardName] =
      scala.Option(impl.dashboardName()).map(value => value: DashboardName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.GetDashboardResponse.ReadOnly =
    new Wrapper(impl)
}
