package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  Timestamp,
  InsightRuleUnboundInteger,
  InsightRuleOrderBy,
  Period,
  InsightRuleMetricName,
  InsightRuleName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetInsightRuleReportRequest(
    ruleName: InsightRuleName,
    startTime: Timestamp,
    endTime: Timestamp,
    period: Period,
    maxContributorCount: Option[InsightRuleUnboundInteger] = None,
    metrics: Option[Iterable[InsightRuleMetricName]] = None,
    orderBy: Option[InsightRuleOrderBy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest = {
    import GetInsightRuleReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
      .builder()
      .ruleName(ruleName: java.lang.String)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .period(period: Integer)
      .optionallyWith(maxContributorCount.map(value => value: Integer))(
        _.maxContributorCount
      )
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(orderBy.map(value => value: java.lang.String))(_.orderBy)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportRequest
      .wrap(buildAwsValue())
}
object GetInsightRuleReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportRequest =
      io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportRequest(
        ruleNameValue,
        startTimeValue,
        endTimeValue,
        periodValue,
        maxContributorCountValue.map(value => value),
        metricsValue.map(value => value),
        orderByValue.map(value => value)
      )
    def ruleNameValue: InsightRuleName
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def periodValue: Period
    def maxContributorCountValue: Option[InsightRuleUnboundInteger]
    def metricsValue: Option[List[InsightRuleMetricName]]
    def orderByValue: Option[InsightRuleOrderBy]
    def ruleName: ZIO[Any, Nothing, InsightRuleName] =
      ZIO.succeed(ruleNameValue)
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, Period] = ZIO.succeed(periodValue)
    def maxContributorCount: ZIO[Any, AwsError, InsightRuleUnboundInteger] =
      AwsError.unwrapOptionField(
        "maxContributorCount",
        maxContributorCountValue
      )
    def metrics: ZIO[Any, AwsError, List[InsightRuleMetricName]] =
      AwsError.unwrapOptionField("metrics", metricsValue)
    def orderBy: ZIO[Any, AwsError, InsightRuleOrderBy] =
      AwsError.unwrapOptionField("orderBy", orderByValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportRequest.ReadOnly {
    override def ruleNameValue: InsightRuleName =
      impl.ruleName(): InsightRuleName
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
    override def periodValue: Period = impl.period(): Period
    override def maxContributorCountValue: Option[InsightRuleUnboundInteger] =
      scala
        .Option(impl.maxContributorCount())
        .map(value => value: InsightRuleUnboundInteger)
    override def metricsValue: Option[List[InsightRuleMetricName]] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          item: InsightRuleMetricName
        }.toList
      )
    override def orderByValue: Option[InsightRuleOrderBy] =
      scala.Option(impl.orderBy()).map(value => value: InsightRuleOrderBy)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportRequest.ReadOnly =
    new Wrapper(impl)
}
