package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleUnboundLong,
  InsightRuleUnboundDouble,
  InsightRuleAggregationStatistic,
  InsightRuleContributorKeyLabel
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInsightRuleReportResponse(
    keyLabels: Option[Iterable[InsightRuleContributorKeyLabel]] = None,
    aggregationStatistic: Option[InsightRuleAggregationStatistic] = None,
    aggregateValue: Option[InsightRuleUnboundDouble] = None,
    approximateUniqueCount: Option[InsightRuleUnboundLong] = None,
    contributors: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor]
    ] = None,
    metricDatapoints: Option[Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse = {
    import GetInsightRuleReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
      .builder()
      .optionallyWith(
        keyLabels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.keyLabels)
      .optionallyWith(
        aggregationStatistic.map(value => value: java.lang.String)
      )(_.aggregationStatistic)
      .optionallyWith(aggregateValue.map(value => value: java.lang.Double))(
        _.aggregateValue
      )
      .optionallyWith(
        approximateUniqueCount.map(value => value: java.lang.Long)
      )(_.approximateUniqueCount)
      .optionallyWith(
        contributors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contributors)
      .optionallyWith(
        metricDatapoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDatapoints)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse
      .wrap(buildAwsValue())
}
object GetInsightRuleReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse =
      io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse(
        keyLabelsValue.map(value => value),
        aggregationStatisticValue.map(value => value),
        aggregateValueValue.map(value => value),
        approximateUniqueCountValue.map(value => value),
        contributorsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        metricDatapointsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def keyLabelsValue: Option[List[InsightRuleContributorKeyLabel]]
    def aggregationStatisticValue: Option[InsightRuleAggregationStatistic]
    def aggregateValueValue: Option[InsightRuleUnboundDouble]
    def approximateUniqueCountValue: Option[InsightRuleUnboundLong]
    def contributorsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor.ReadOnly
    ]]
    def metricDatapointsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly
    ]]
    def keyLabels: ZIO[Any, AwsError, List[InsightRuleContributorKeyLabel]] =
      AwsError.unwrapOptionField("keyLabels", keyLabelsValue)
    def aggregationStatistic
        : ZIO[Any, AwsError, InsightRuleAggregationStatistic] = AwsError
      .unwrapOptionField("aggregationStatistic", aggregationStatisticValue)
    def aggregateValue: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("aggregateValue", aggregateValueValue)
    def approximateUniqueCount: ZIO[Any, AwsError, InsightRuleUnboundLong] =
      AwsError.unwrapOptionField(
        "approximateUniqueCount",
        approximateUniqueCountValue
      )
    def contributors: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor.ReadOnly
    ]] = AwsError.unwrapOptionField("contributors", contributorsValue)
    def metricDatapoints: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDatapoints", metricDatapointsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly {
    override def keyLabelsValue: Option[List[InsightRuleContributorKeyLabel]] =
      scala
        .Option(impl.keyLabels())
        .map(value =>
          value.asScala.map { item =>
            item: InsightRuleContributorKeyLabel
          }.toList
        )
    override def aggregationStatisticValue
        : Option[InsightRuleAggregationStatistic] = scala
      .Option(impl.aggregationStatistic())
      .map(value => value: InsightRuleAggregationStatistic)
    override def aggregateValueValue: Option[InsightRuleUnboundDouble] = scala
      .Option(impl.aggregateValue())
      .map(value => value: InsightRuleUnboundDouble)
    override def approximateUniqueCountValue: Option[InsightRuleUnboundLong] =
      scala
        .Option(impl.approximateUniqueCount())
        .map(value => value: InsightRuleUnboundLong)
    override def contributorsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor.ReadOnly
    ]] = scala
      .Option(impl.contributors())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor
            .wrap(item)
        }.toList
      )
    override def metricDatapointsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly
    ]] = scala
      .Option(impl.metricDatapoints())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.GetInsightRuleReportResponse.ReadOnly =
    new Wrapper(impl)
}
