package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  GetMetricDataMaxDatapoints,
  NextToken,
  Timestamp
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetMetricDataRequest(
    metricDataQueries: Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery
    ],
    startTime: Timestamp,
    endTime: Timestamp,
    nextToken: Option[NextToken] = None,
    scanBy: Option[io.github.vigoo.zioaws.cloudwatch.model.ScanBy] = None,
    maxDatapoints: Option[GetMetricDataMaxDatapoints] = None,
    labelOptions: Option[io.github.vigoo.zioaws.cloudwatch.model.LabelOptions] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest = {
    import GetMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
      .builder()
      .metricDataQueries(metricDataQueries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(scanBy.map(value => value.unwrap))(_.scanBy)
      .optionallyWith(maxDatapoints.map(value => value: Integer))(
        _.maxDatapoints
      )
      .optionallyWith(labelOptions.map(value => value.buildAwsValue()))(
        _.labelOptions
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataRequest
      .wrap(buildAwsValue())
}
object GetMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataRequest =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataRequest(
        metricDataQueriesValue.map { item =>
          item.editable
        },
        startTimeValue,
        endTimeValue,
        nextTokenValue.map(value => value),
        scanByValue.map(value => value),
        maxDatapointsValue.map(value => value),
        labelOptionsValue.map(value => value.editable)
      )
    def metricDataQueriesValue
        : List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly]
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def nextTokenValue: Option[NextToken]
    def scanByValue: Option[io.github.vigoo.zioaws.cloudwatch.model.ScanBy]
    def maxDatapointsValue: Option[GetMetricDataMaxDatapoints]
    def labelOptionsValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.ReadOnly]
    def metricDataQueries: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly
    ]] = ZIO.succeed(metricDataQueriesValue)
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def scanBy
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.cloudwatch.model.ScanBy] =
      AwsError.unwrapOptionField("scanBy", scanByValue)
    def maxDatapoints: ZIO[Any, AwsError, GetMetricDataMaxDatapoints] =
      AwsError.unwrapOptionField("maxDatapoints", maxDatapointsValue)
    def labelOptions: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.ReadOnly
    ] = AwsError.unwrapOptionField("labelOptions", labelOptionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataRequest.ReadOnly {
    override def metricDataQueriesValue: List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.ReadOnly
    ] = impl
      .metricDataQueries()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.cloudwatch.model.MetricDataQuery.wrap(item)
      }
      .toList
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def scanByValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.ScanBy] = scala
      .Option(impl.scanBy())
      .map(value => io.github.vigoo.zioaws.cloudwatch.model.ScanBy.wrap(value))
    override def maxDatapointsValue: Option[GetMetricDataMaxDatapoints] = scala
      .Option(impl.maxDatapoints())
      .map(value => value: GetMetricDataMaxDatapoints)
    override def labelOptionsValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.ReadOnly
    ] = scala
      .Option(impl.labelOptions())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
