package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMetricDataResponse(
    metricDataResults: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult]
    ] = None,
    nextToken: Option[NextToken] = None,
    messages: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MessageData]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse = {
    import GetMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
      .builder()
      .optionallyWith(
        metricDataResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDataResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataResponse
      .wrap(buildAwsValue())
}
object GetMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataResponse =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataResponse(
        metricDataResultsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value),
        messagesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def metricDataResultsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def messagesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly]
    ]
    def metricDataResults: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDataResults", metricDataResultsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def messages: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messagesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataResponse.ReadOnly {
    override def metricDataResultsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.ReadOnly]
    ] = scala
      .Option(impl.metricDataResults())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricDataResult.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def messagesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MessageData.ReadOnly]
    ] = scala
      .Option(impl.messages())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MessageData.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
