package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  MetricName,
  ExtendedStatistic,
  Namespace,
  Timestamp,
  Period
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetMetricStatisticsRequest(
    namespace: Namespace,
    metricName: MetricName,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Dimension]
    ] = None,
    startTime: Timestamp,
    endTime: Timestamp,
    period: Period,
    statistics: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Statistic]
    ] = None,
    extendedStatistics: Option[Iterable[ExtendedStatistic]] = None,
    unit: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest = {
    import GetMetricStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
      .builder()
      .namespace(namespace: java.lang.String)
      .metricName(metricName: java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .period(period: Integer)
      .optionallyWith(
        statistics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statisticsWithStrings)
      .optionallyWith(
        extendedStatistics.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.extendedStatistics)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsRequest
      .wrap(buildAwsValue())
}
object GetMetricStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsRequest =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsRequest(
        namespaceValue,
        metricNameValue,
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        startTimeValue,
        endTimeValue,
        periodValue,
        statisticsValue.map(value => value),
        extendedStatisticsValue.map(value => value),
        unitValue.map(value => value)
      )
    def namespaceValue: Namespace
    def metricNameValue: MetricName
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ]
    def startTimeValue: Timestamp
    def endTimeValue: Timestamp
    def periodValue: Period
    def statisticsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Statistic]]
    def extendedStatisticsValue: Option[List[ExtendedStatistic]]
    def unitValue: Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit]
    def namespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespaceValue)
    def metricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def startTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, Period] = ZIO.succeed(periodValue)
    def statistics: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Statistic
    ]] = AwsError.unwrapOptionField("statistics", statisticsValue)
    def extendedStatistics: ZIO[Any, AwsError, List[ExtendedStatistic]] =
      AwsError.unwrapOptionField("extendedStatistics", extendedStatisticsValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.StandardUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsRequest.ReadOnly {
    override def namespaceValue: Namespace = impl.namespace(): Namespace
    override def metricNameValue: MetricName = impl.metricName(): MetricName
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Dimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Dimension.wrap(item)
        }.toList
      )
    override def startTimeValue: Timestamp = impl.startTime(): Timestamp
    override def endTimeValue: Timestamp = impl.endTime(): Timestamp
    override def periodValue: Period = impl.period(): Period
    override def statisticsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Statistic]] =
      scala
        .Option(impl.statistics())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Statistic.wrap(item)
          }.toList
        )
    override def extendedStatisticsValue: Option[List[ExtendedStatistic]] =
      scala
        .Option(impl.extendedStatistics())
        .map(value =>
          value.asScala.map { item =>
            item: ExtendedStatistic
          }.toList
        )
    override def unitValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.StandardUnit] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.StandardUnit.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
