package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricLabel
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMetricStatisticsResponse(
    label: Option[MetricLabel] = None,
    datapoints: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.Datapoint]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse = {
    import GetMetricStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
      .builder()
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(
        datapoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datapoints)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse
      .wrap(buildAwsValue())
}
object GetMetricStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse(
        labelValue.map(value => value),
        datapointsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def labelValue: Option[MetricLabel]
    def datapointsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Datapoint.ReadOnly]
    ]
    def label: ZIO[Any, AwsError, MetricLabel] =
      AwsError.unwrapOptionField("label", labelValue)
    def datapoints: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Datapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("datapoints", datapointsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly {
    override def labelValue: Option[MetricLabel] =
      scala.Option(impl.label()).map(value => value: MetricLabel)
    override def datapointsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Datapoint.ReadOnly]
    ] = scala
      .Option(impl.datapoints())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Datapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
