package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricStreamName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMetricStreamRequest(name: MetricStreamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest = {
    import GetMetricStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
      .builder()
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamRequest
      .wrap(buildAwsValue())
}
object GetMetricStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamRequest =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamRequest(nameValue)
    def nameValue: MetricStreamName
    def name: ZIO[Any, Nothing, MetricStreamName] = ZIO.succeed(nameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamRequest.ReadOnly {
    override def nameValue: MetricStreamName = impl.name(): MetricStreamName
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamRequest.ReadOnly =
    new Wrapper(impl)
}
