package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  Timestamp,
  MetricStreamState,
  MetricStreamName,
  AmazonResourceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMetricStreamResponse(
    arn: Option[AmazonResourceName] = None,
    name: Option[MetricStreamName] = None,
    includeFilters: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter]
    ] = None,
    excludeFilters: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter]
    ] = None,
    firehoseArn: Option[AmazonResourceName] = None,
    roleArn: Option[AmazonResourceName] = None,
    state: Option[MetricStreamState] = None,
    creationDate: Option[Timestamp] = None,
    lastUpdateDate: Option[Timestamp] = None,
    outputFormat: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = None,
    statisticsConfigurations: Option[Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse = {
    import GetMetricStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        includeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includeFilters)
      .optionallyWith(
        excludeFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludeFilters)
      .optionallyWith(firehoseArn.map(value => value: java.lang.String))(
        _.firehoseArn
      )
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(creationDate.map(value => value: Instant))(_.creationDate)
      .optionallyWith(lastUpdateDate.map(value => value: Instant))(
        _.lastUpdateDate
      )
      .optionallyWith(outputFormat.map(value => value.unwrap))(_.outputFormat)
      .optionallyWith(
        statisticsConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statisticsConfigurations)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse
      .wrap(buildAwsValue())
}
object GetMetricStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse(
        arnValue.map(value => value),
        nameValue.map(value => value),
        includeFiltersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        excludeFiltersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        firehoseArnValue.map(value => value),
        roleArnValue.map(value => value),
        stateValue.map(value => value),
        creationDateValue.map(value => value),
        lastUpdateDateValue.map(value => value),
        outputFormatValue.map(value => value),
        statisticsConfigurationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def arnValue: Option[AmazonResourceName]
    def nameValue: Option[MetricStreamName]
    def includeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ]
    def excludeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ]
    def firehoseArnValue: Option[AmazonResourceName]
    def roleArnValue: Option[AmazonResourceName]
    def stateValue: Option[MetricStreamState]
    def creationDateValue: Option[Timestamp]
    def lastUpdateDateValue: Option[Timestamp]
    def outputFormatValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ]
    def statisticsConfigurationsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]]
    def arn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, AwsError, MetricStreamName] =
      AwsError.unwrapOptionField("name", nameValue)
    def includeFilters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("includeFilters", includeFiltersValue)
    def excludeFilters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("excludeFilters", excludeFiltersValue)
    def firehoseArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("firehoseArn", firehoseArnValue)
    def roleArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("roleArn", roleArnValue)
    def state: ZIO[Any, AwsError, MetricStreamState] =
      AwsError.unwrapOptionField("state", stateValue)
    def creationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDateValue)
    def lastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDateValue)
    def outputFormat: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = AwsError.unwrapOptionField("outputFormat", outputFormatValue)
    def statisticsConfigurations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "statisticsConfigurations",
      statisticsConfigurationsValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly {
    override def arnValue: Option[AmazonResourceName] =
      scala.Option(impl.arn()).map(value => value: AmazonResourceName)
    override def nameValue: Option[MetricStreamName] =
      scala.Option(impl.name()).map(value => value: MetricStreamName)
    override def includeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ] = scala
      .Option(impl.includeFilters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.wrap(item)
        }.toList
      )
    override def excludeFiltersValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.ReadOnly]
    ] = scala
      .Option(impl.excludeFilters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamFilter.wrap(item)
        }.toList
      )
    override def firehoseArnValue: Option[AmazonResourceName] =
      scala.Option(impl.firehoseArn()).map(value => value: AmazonResourceName)
    override def roleArnValue: Option[AmazonResourceName] =
      scala.Option(impl.roleArn()).map(value => value: AmazonResourceName)
    override def stateValue: Option[MetricStreamState] =
      scala.Option(impl.state()).map(value => value: MetricStreamState)
    override def creationDateValue: Option[Timestamp] =
      scala.Option(impl.creationDate()).map(value => value: Timestamp)
    override def lastUpdateDateValue: Option[Timestamp] =
      scala.Option(impl.lastUpdateDate()).map(value => value: Timestamp)
    override def outputFormatValue: Option[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
    ] = scala
      .Option(impl.outputFormat())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.MetricStreamOutputFormat
          .wrap(value)
      )
    override def statisticsConfigurationsValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration.ReadOnly
    ]] = scala
      .Option(impl.statisticsConfigurations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamStatisticsConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricStreamResponse.ReadOnly =
    new Wrapper(impl)
}
