package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  OutputFormat,
  MetricWidget
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMetricWidgetImageRequest(
    metricWidget: MetricWidget,
    outputFormat: Option[OutputFormat] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest = {
    import GetMetricWidgetImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
      .builder()
      .metricWidget(metricWidget: java.lang.String)
      .optionallyWith(outputFormat.map(value => value: java.lang.String))(
        _.outputFormat
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageRequest
      .wrap(buildAwsValue())
}
object GetMetricWidgetImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageRequest =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageRequest(
        metricWidgetValue,
        outputFormatValue.map(value => value)
      )
    def metricWidgetValue: MetricWidget
    def outputFormatValue: Option[OutputFormat]
    def metricWidget: ZIO[Any, Nothing, MetricWidget] =
      ZIO.succeed(metricWidgetValue)
    def outputFormat: ZIO[Any, AwsError, OutputFormat] =
      AwsError.unwrapOptionField("outputFormat", outputFormatValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageRequest.ReadOnly {
    override def metricWidgetValue: MetricWidget =
      impl.metricWidget(): MetricWidget
    override def outputFormatValue: Option[OutputFormat] =
      scala.Option(impl.outputFormat()).map(value => value: OutputFormat)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageRequest.ReadOnly =
    new Wrapper(impl)
}
