package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.MetricWidgetImage
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetMetricWidgetImageResponse(
    metricWidgetImage: Option[MetricWidgetImage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse = {
    import GetMetricWidgetImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
      .builder()
      .optionallyWith(
        metricWidgetImage.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.metricWidgetImage)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse
      .wrap(buildAwsValue())
}
object GetMetricWidgetImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse =
      io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse(
        metricWidgetImageValue.map(value => value)
      )
    def metricWidgetImageValue: Option[MetricWidgetImage]
    def metricWidgetImage: ZIO[Any, AwsError, MetricWidgetImage] =
      AwsError.unwrapOptionField("metricWidgetImage", metricWidgetImageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly {
    override def metricWidgetImageValue: Option[MetricWidgetImage] = scala
      .Option(impl.metricWidgetImage())
      .map(value => zio.Chunk.fromArray(value.asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.GetMetricWidgetImageResponse.ReadOnly =
    new Wrapper(impl)
}
