package io.github.vigoo.zioaws.cloudwatch.model
import scala.jdk.CollectionConverters._
sealed trait HistoryItemType {
  def unwrap: software.amazon.awssdk.services.cloudwatch.model.HistoryItemType
}
object HistoryItemType {
  def wrap(
      value: software.amazon.awssdk.services.cloudwatch.model.HistoryItemType
  ): io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType = value match {
    case software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.CONFIGURATION_UPDATE =>
      val r = ConfigurationUpdate
      r
    case software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.STATE_UPDATE =>
      val r = StateUpdate
      r
    case software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.ACTION =>
      val r = Action
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.HistoryItemType =
      software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.UNKNOWN_TO_SDK_VERSION
  }
  case object ConfigurationUpdate
      extends io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.HistoryItemType =
      software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.CONFIGURATION_UPDATE
  }
  case object StateUpdate
      extends io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.HistoryItemType =
      software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.STATE_UPDATE
  }
  case object Action
      extends io.github.vigoo.zioaws.cloudwatch.model.HistoryItemType {
    override def unwrap
        : software.amazon.awssdk.services.cloudwatch.model.HistoryItemType =
      software.amazon.awssdk.services.cloudwatch.model.HistoryItemType.ACTION
  }
}
