package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleState,
  InsightRuleSchema,
  InsightRuleIsManaged,
  InsightRuleDefinition,
  InsightRuleName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InsightRule(
    name: InsightRuleName,
    state: InsightRuleState,
    schema: InsightRuleSchema,
    definition: InsightRuleDefinition,
    managedRule: Option[InsightRuleIsManaged] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRule = {
    import InsightRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRule
      .builder()
      .name(name: java.lang.String)
      .state(state: java.lang.String)
      .schema(schema: java.lang.String)
      .definition(definition: java.lang.String)
      .optionallyWith(managedRule.map(value => value: java.lang.Boolean))(
        _.managedRule
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.InsightRule.wrap(buildAwsValue())
}
object InsightRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.InsightRule =
      io.github.vigoo.zioaws.cloudwatch.model.InsightRule(
        nameValue,
        stateValue,
        schemaValue,
        definitionValue,
        managedRuleValue.map(value => value)
      )
    def nameValue: InsightRuleName
    def stateValue: InsightRuleState
    def schemaValue: InsightRuleSchema
    def definitionValue: InsightRuleDefinition
    def managedRuleValue: Option[InsightRuleIsManaged]
    def name: ZIO[Any, Nothing, InsightRuleName] = ZIO.succeed(nameValue)
    def state: ZIO[Any, Nothing, InsightRuleState] = ZIO.succeed(stateValue)
    def schema: ZIO[Any, Nothing, InsightRuleSchema] = ZIO.succeed(schemaValue)
    def definition: ZIO[Any, Nothing, InsightRuleDefinition] =
      ZIO.succeed(definitionValue)
    def managedRule: ZIO[Any, AwsError, InsightRuleIsManaged] =
      AwsError.unwrapOptionField("managedRule", managedRuleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRule
  ) extends io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly {
    override def nameValue: InsightRuleName = impl.name(): InsightRuleName
    override def stateValue: InsightRuleState = impl.state(): InsightRuleState
    override def schemaValue: InsightRuleSchema =
      impl.schema(): InsightRuleSchema
    override def definitionValue: InsightRuleDefinition =
      impl.definition(): InsightRuleDefinition
    override def managedRuleValue: Option[InsightRuleIsManaged] =
      scala.Option(impl.managedRule()).map(value => value: InsightRuleIsManaged)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRule
  ): io.github.vigoo.zioaws.cloudwatch.model.InsightRule.ReadOnly = new Wrapper(
    impl
  )
}
