package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleUnboundDouble,
  InsightRuleContributorKey
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InsightRuleContributor(
    keys: Iterable[InsightRuleContributorKey],
    approximateAggregateValue: InsightRuleUnboundDouble,
    datapoints: Iterable[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor = {
    import InsightRuleContributor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
      .builder()
      .keys(keys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .approximateAggregateValue(approximateAggregateValue: java.lang.Double)
      .datapoints(datapoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor
      .wrap(buildAwsValue())
}
object InsightRuleContributor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor =
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor(
        keysValue,
        approximateAggregateValueValue,
        datapointsValue.map { item =>
          item.editable
        }
      )
    def keysValue: List[InsightRuleContributorKey]
    def approximateAggregateValueValue: InsightRuleUnboundDouble
    def datapointsValue: List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly
    ]
    def keys: ZIO[Any, Nothing, List[InsightRuleContributorKey]] =
      ZIO.succeed(keysValue)
    def approximateAggregateValue: ZIO[Any, Nothing, InsightRuleUnboundDouble] =
      ZIO.succeed(approximateAggregateValueValue)
    def datapoints: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly
    ]] = ZIO.succeed(datapointsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
  ) extends io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor.ReadOnly {
    override def keysValue: List[InsightRuleContributorKey] = impl
      .keys()
      .asScala
      .map { item =>
        item: InsightRuleContributorKey
      }
      .toList
    override def approximateAggregateValueValue: InsightRuleUnboundDouble =
      impl.approximateAggregateValue(): InsightRuleUnboundDouble
    override def datapointsValue: List[
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly
    ] = impl
      .datapoints()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributor
  ): io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributor.ReadOnly =
    new Wrapper(impl)
}
