package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleUnboundDouble,
  Timestamp
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InsightRuleContributorDatapoint(
    timestamp: Timestamp,
    approximateValue: InsightRuleUnboundDouble
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint = {
    import InsightRuleContributorDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
      .builder()
      .timestamp(timestamp: Instant)
      .approximateValue(approximateValue: java.lang.Double)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint
      .wrap(buildAwsValue())
}
object InsightRuleContributorDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint =
      io.github.vigoo.zioaws.cloudwatch.model
        .InsightRuleContributorDatapoint(timestampValue, approximateValueValue)
    def timestampValue: Timestamp
    def approximateValueValue: InsightRuleUnboundDouble
    def timestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestampValue)
    def approximateValue: ZIO[Any, Nothing, InsightRuleUnboundDouble] =
      ZIO.succeed(approximateValueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
  ) extends io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly {
    override def timestampValue: Timestamp = impl.timestamp(): Timestamp
    override def approximateValueValue: InsightRuleUnboundDouble =
      impl.approximateValue(): InsightRuleUnboundDouble
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint
  ): io.github.vigoo.zioaws.cloudwatch.model.InsightRuleContributorDatapoint.ReadOnly =
    new Wrapper(impl)
}
