package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleUnboundDouble,
  Timestamp
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InsightRuleMetricDatapoint(
    timestamp: Timestamp,
    uniqueContributors: Option[InsightRuleUnboundDouble] = None,
    maxContributorValue: Option[InsightRuleUnboundDouble] = None,
    sampleCount: Option[InsightRuleUnboundDouble] = None,
    average: Option[InsightRuleUnboundDouble] = None,
    sum: Option[InsightRuleUnboundDouble] = None,
    minimum: Option[InsightRuleUnboundDouble] = None,
    maximum: Option[InsightRuleUnboundDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint = {
    import InsightRuleMetricDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
      .builder()
      .timestamp(timestamp: Instant)
      .optionallyWith(uniqueContributors.map(value => value: java.lang.Double))(
        _.uniqueContributors
      )
      .optionallyWith(
        maxContributorValue.map(value => value: java.lang.Double)
      )(_.maxContributorValue)
      .optionallyWith(sampleCount.map(value => value: java.lang.Double))(
        _.sampleCount
      )
      .optionallyWith(average.map(value => value: java.lang.Double))(_.average)
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint
      .wrap(buildAwsValue())
}
object InsightRuleMetricDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint =
      io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint(
        timestampValue,
        uniqueContributorsValue.map(value => value),
        maxContributorValueValue.map(value => value),
        sampleCountValue.map(value => value),
        averageValue.map(value => value),
        sumValue.map(value => value),
        minimumValue.map(value => value),
        maximumValue.map(value => value)
      )
    def timestampValue: Timestamp
    def uniqueContributorsValue: Option[InsightRuleUnboundDouble]
    def maxContributorValueValue: Option[InsightRuleUnboundDouble]
    def sampleCountValue: Option[InsightRuleUnboundDouble]
    def averageValue: Option[InsightRuleUnboundDouble]
    def sumValue: Option[InsightRuleUnboundDouble]
    def minimumValue: Option[InsightRuleUnboundDouble]
    def maximumValue: Option[InsightRuleUnboundDouble]
    def timestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestampValue)
    def uniqueContributors: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("uniqueContributors", uniqueContributorsValue)
    def maxContributorValue: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField(
        "maxContributorValue",
        maxContributorValueValue
      )
    def sampleCount: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("sampleCount", sampleCountValue)
    def average: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("average", averageValue)
    def sum: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("sum", sumValue)
    def minimum: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("minimum", minimumValue)
    def maximum: ZIO[Any, AwsError, InsightRuleUnboundDouble] =
      AwsError.unwrapOptionField("maximum", maximumValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
  ) extends io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly {
    override def timestampValue: Timestamp = impl.timestamp(): Timestamp
    override def uniqueContributorsValue: Option[InsightRuleUnboundDouble] =
      scala
        .Option(impl.uniqueContributors())
        .map(value => value: InsightRuleUnboundDouble)
    override def maxContributorValueValue: Option[InsightRuleUnboundDouble] =
      scala
        .Option(impl.maxContributorValue())
        .map(value => value: InsightRuleUnboundDouble)
    override def sampleCountValue: Option[InsightRuleUnboundDouble] = scala
      .Option(impl.sampleCount())
      .map(value => value: InsightRuleUnboundDouble)
    override def averageValue: Option[InsightRuleUnboundDouble] =
      scala.Option(impl.average()).map(value => value: InsightRuleUnboundDouble)
    override def sumValue: Option[InsightRuleUnboundDouble] =
      scala.Option(impl.sum()).map(value => value: InsightRuleUnboundDouble)
    override def minimumValue: Option[InsightRuleUnboundDouble] =
      scala.Option(impl.minimum()).map(value => value: InsightRuleUnboundDouble)
    override def maximumValue: Option[InsightRuleUnboundDouble] =
      scala.Option(impl.maximum()).map(value => value: InsightRuleUnboundDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.InsightRuleMetricDatapoint
  ): io.github.vigoo.zioaws.cloudwatch.model.InsightRuleMetricDatapoint.ReadOnly =
    new Wrapper(impl)
}
