package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.GetMetricDataLabelTimezone
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LabelOptions(
    timezone: Option[GetMetricDataLabelTimezone] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.LabelOptions = {
    import LabelOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.LabelOptions
      .builder()
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.wrap(buildAwsValue())
}
object LabelOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.LabelOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.LabelOptions =
      io.github.vigoo.zioaws.cloudwatch.model
        .LabelOptions(timezoneValue.map(value => value))
    def timezoneValue: Option[GetMetricDataLabelTimezone]
    def timezone: ZIO[Any, AwsError, GetMetricDataLabelTimezone] =
      AwsError.unwrapOptionField("timezone", timezoneValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.LabelOptions
  ) extends io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.ReadOnly {
    override def timezoneValue: Option[GetMetricDataLabelTimezone] = scala
      .Option(impl.timezone())
      .map(value => value: GetMetricDataLabelTimezone)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.LabelOptions
  ): io.github.vigoo.zioaws.cloudwatch.model.LabelOptions.ReadOnly =
    new Wrapper(impl)
}
