package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  NextToken,
  DashboardNamePrefix
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDashboardsRequest(
    dashboardNamePrefix: Option[DashboardNamePrefix] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest = {
    import ListDashboardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
      .builder()
      .optionallyWith(
        dashboardNamePrefix.map(value => value: java.lang.String)
      )(_.dashboardNamePrefix)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsRequest
      .wrap(buildAwsValue())
}
object ListDashboardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsRequest =
      io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsRequest(
        dashboardNamePrefixValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def dashboardNamePrefixValue: Option[DashboardNamePrefix]
    def nextTokenValue: Option[NextToken]
    def dashboardNamePrefix: ZIO[Any, AwsError, DashboardNamePrefix] = AwsError
      .unwrapOptionField("dashboardNamePrefix", dashboardNamePrefixValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsRequest.ReadOnly {
    override def dashboardNamePrefixValue: Option[DashboardNamePrefix] = scala
      .Option(impl.dashboardNamePrefix())
      .map(value => value: DashboardNamePrefix)
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsRequest.ReadOnly =
    new Wrapper(impl)
}
