package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDashboardsResponse(
    dashboardEntries: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse = {
    import ListDashboardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
      .builder()
      .optionallyWith(
        dashboardEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dashboardEntries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsResponse
      .wrap(buildAwsValue())
}
object ListDashboardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsResponse =
      io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsResponse(
        dashboardEntriesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def dashboardEntriesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def dashboardEntries: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("dashboardEntries", dashboardEntriesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsResponse.ReadOnly {
    override def dashboardEntriesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.ReadOnly]
    ] = scala
      .Option(impl.dashboardEntries())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.DashboardEntry.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.ListDashboardsResponse.ReadOnly =
    new Wrapper(impl)
}
