package io.github.vigoo.zioaws.cloudwatch.model
import java.lang.Integer
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  InsightRuleMaxResults,
  NextToken,
  AmazonResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListManagedInsightRulesRequest(
    resourceARN: AmazonResourceName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[InsightRuleMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest = {
    import ListManagedInsightRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
      .builder()
      .resourceARN(resourceARN: java.lang.String)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesRequest
      .wrap(buildAwsValue())
}
object ListManagedInsightRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesRequest =
      io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesRequest(
        resourceARNValue,
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def resourceARNValue: AmazonResourceName
    def nextTokenValue: Option[NextToken]
    def maxResultsValue: Option[InsightRuleMaxResults]
    def resourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARNValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, InsightRuleMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesRequest.ReadOnly {
    override def resourceARNValue: AmazonResourceName =
      impl.resourceARN(): AmazonResourceName
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def maxResultsValue: Option[InsightRuleMaxResults] =
      scala.Option(impl.maxResults()).map(value => value: InsightRuleMaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesRequest.ReadOnly =
    new Wrapper(impl)
}
