package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListManagedInsightRulesResponse(
    managedRules: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse = {
    import ListManagedInsightRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
      .builder()
      .optionallyWith(
        managedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedRules)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesResponse
      .wrap(buildAwsValue())
}
object ListManagedInsightRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesResponse =
      io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesResponse(
        managedRulesValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def managedRulesValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
    ]]
    def nextTokenValue: Option[NextToken]
    def managedRules: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("managedRules", managedRulesValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly {
    override def managedRulesValue: Option[List[
      io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription.ReadOnly
    ]] = scala
      .Option(impl.managedRules())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.ManagedRuleDescription
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.ListManagedInsightRulesResponse.ReadOnly =
    new Wrapper(impl)
}
