package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMetricStreamsResponse(
    nextToken: Option[NextToken] = None,
    entries: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse = {
    import ListMetricStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListMetricStreamsResponse
      .wrap(buildAwsValue())
}
object ListMetricStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ListMetricStreamsResponse =
      io.github.vigoo.zioaws.cloudwatch.model.ListMetricStreamsResponse(
        nextTokenValue.map(value => value),
        entriesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def nextTokenValue: Option[NextToken]
    def entriesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly]
    ]
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def entries: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entriesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly {
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def entriesValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.ReadOnly]
    ] = scala
      .Option(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.MetricStreamEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.ListMetricStreamsResponse.ReadOnly =
    new Wrapper(impl)
}
