package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.{
  NextToken,
  MetricName,
  Namespace
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMetricsRequest(
    namespace: Option[Namespace] = None,
    metricName: Option[MetricName] = None,
    dimensions: Option[
      Iterable[io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter]
    ] = None,
    nextToken: Option[NextToken] = None,
    recentlyActive: Option[
      io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest = {
    import ListMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
      .builder()
      .optionallyWith(namespace.map(value => value: java.lang.String))(
        _.namespace
      )
      .optionallyWith(metricName.map(value => value: java.lang.String))(
        _.metricName
      )
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(recentlyActive.map(value => value.unwrap))(
        _.recentlyActive
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListMetricsRequest.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListMetricsRequest
      .wrap(buildAwsValue())
}
object ListMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.ListMetricsRequest =
      io.github.vigoo.zioaws.cloudwatch.model.ListMetricsRequest(
        namespaceValue.map(value => value),
        metricNameValue.map(value => value),
        dimensionsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value),
        recentlyActiveValue.map(value => value)
      )
    def namespaceValue: Option[Namespace]
    def metricNameValue: Option[MetricName]
    def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.ReadOnly]
    ]
    def nextTokenValue: Option[NextToken]
    def recentlyActiveValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive]
    def namespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespaceValue)
    def metricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricNameValue)
    def dimensions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensionsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def recentlyActive: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive
    ] = AwsError.unwrapOptionField("recentlyActive", recentlyActiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListMetricsRequest.ReadOnly {
    override def namespaceValue: Option[Namespace] =
      scala.Option(impl.namespace()).map(value => value: Namespace)
    override def metricNameValue: Option[MetricName] =
      scala.Option(impl.metricName()).map(value => value: MetricName)
    override def dimensionsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.DimensionFilter.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
    override def recentlyActiveValue
        : Option[io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive] = scala
      .Option(impl.recentlyActive())
      .map(value =>
        io.github.vigoo.zioaws.cloudwatch.model.RecentlyActive.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest
  ): io.github.vigoo.zioaws.cloudwatch.model.ListMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
