package io.github.vigoo.zioaws.cloudwatch.model
import io.github.vigoo.zioaws.cloudwatch.model.primitives.NextToken
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMetricsResponse(
    metrics: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Metric]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse = {
    import ListMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
      .builder()
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListMetricsResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListMetricsResponse
      .wrap(buildAwsValue())
}
object ListMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.cloudwatch.model.ListMetricsResponse =
      io.github.vigoo.zioaws.cloudwatch.model.ListMetricsResponse(
        metricsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value)
      )
    def metricsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly]]
    def nextTokenValue: Option[NextToken]
    def metrics: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metricsValue)
    def nextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListMetricsResponse.ReadOnly {
    override def metricsValue: Option[
      List[io.github.vigoo.zioaws.cloudwatch.model.Metric.ReadOnly]
    ] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.cloudwatch.model.Metric.wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[NextToken] =
      scala.Option(impl.nextToken()).map(value => value: NextToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.ListMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
