package io.github.vigoo.zioaws.cloudwatch.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[io.github.vigoo.zioaws.cloudwatch.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly =
    io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse =
      io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse(
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]]
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse
  ) extends io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly {
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.cloudwatch.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.cloudwatch.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse
  ): io.github.vigoo.zioaws.cloudwatch.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
